import platform
import os


# ANSI escape codes
# voir https://en.wikipedia.org/wiki/ANSI_escape_code

def print_at_xy(x: int, y: int, s: str):
    print(f"\033[{y};{x}H{s}")


def hide_cursor():
    print("\033[?25l")


def show_cursor():
    print("\033[?25h")


def clean_screen():
    if platform.system() == "Windows":
        os.system("cls")
    else:
        print("\033[2J")


class Board:
    def __init__(self, width: int, height: int):
        self.width = width
        self.height = height
        clean_screen()
        self.draw_border()

    def draw_border(self):
        for y in range(1, self.height + 1):
            if y == 1 or y == self.height:
                print_at_xy(1, y, "X" * self.width)
            else:
                print_at_xy(1, y, "X" + " " * (self.width - 2) + "X")

    def draw_entities(self, entities: list):
        for entity in entities:
            print_at_xy(entity.pos.x, entity.pos.y, entity.name)


if __name__ == "__main__":
    from collections import namedtuple

    Point = namedtuple("Point", ["x", "y"])
    Entity = namedtuple("Entity", ["pos", "name"])
    board = Board(20, 10)
    entityA = Entity(Point(x=2, y=2), name="A")
    entityB = Entity(Point(x=19, y=9), name="B")
    board.draw_entities([entityA, entityB])
    print_at_xy(1, 11, "")
