class Model:
    def __init__(self, value=0):
        self.state = value

    def setstate(self, value):
        self.state = value

    def getstate(self):
        return self.state

    def do(self):
        self.state += 1


class View:
    def __init__(self, controller):
        self.controller = controller
        self.controller.inscrire(self)

    def show(self, value):
        print('Etat du modèle : {}'.format(value))

    def click(self):
        value = input('Veuillez saisir un état initial : ')
        self.controller.do(value)

    def refresh(self):
        value = self.controller.getstate()
        self.show(value)


class Controller:
    def __init__(self):
        self.clients = []
        self.model = Model()

    def inscrire(self, newclient):
        self.clients.append(newclient)

    def avertir(self):
        for client in self.clients:
            client.refresh()

    def getstate(self):
        return str(self.model.getstate())

    def do(self, value):
        self.model.setstate(int(value))
        self.model.do()
        self.avertir()


c = Controller()
v = View(c)
v.click()
