import random
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
import matplotlib.pyplot as plt
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas

from TEMPLATE_CONTROLEUR import Controler


# TODO : remplacer QGroupBox par QWidget pour supprimer les cadres et les titres de widget.
# QgroupBox permet ici de visualiser graphiquement la layout de l'application.

class ChartsWidget(QGroupBox):
    def __init__(self, parent, controler):
        super().__init__(parent)
        self.controler = controler
        self.controler.addClient(self)
        self.setTitle("ChartsWidget")
        layout = QVBoxLayout()
        self.figure = plt.figure()
        self.canvas = FigureCanvas(self.figure)
        self.canvas.draw()
        layout.addWidget(self.canvas)
        self.setLayout(layout)
        self.drawgraph()

    def drawgraph(self):
        ax = self.figure.add_subplot(111)
        ax.set_title("graphique de test", fontsize=10)
        x = list(range(20))
        y = [random.random() for _ in x]
        ax.plot(x, y)
        self.figure.tight_layout()
        self.canvas.draw()

    def refresh(self):
        pass


class LogWidget(QTextEdit):
    def __init__(self, parent, controler):
        super().__init__(parent)
        self.controler = controler
        self.controler.addClient(self)
        self.setFixedHeight(150)
        self.setReadOnly(True)
        self.append("LogWidget")

    def refresh(self):
        message = self.controler.message
        if message:
            self.append(message)


class ParamsWidget(QGroupBox):
    def __init__(self, parent, controler):
        super().__init__(parent)
        self.controler = controler
        self.controler.addClient(self)
        self.setTitle("ParamsWidget")
        self.setFixedWidth(300)

    def refresh(self):
        pass


class MainWidget(QGroupBox):
    def __init__(self, parent, controler):
        super().__init__(parent)
        self.setMinimumSize(640, 480)
        vlayout = QVBoxLayout()
        hlayout = QHBoxLayout()
        self.paramswidget = ParamsWidget(self, controler)
        self.chartswidget = ChartsWidget(self, controler)
        self.logwidget = LogWidget(self, controler)
        hlayout.addWidget(self.paramswidget, 0)
        hlayout.addWidget(self.chartswidget, 1)
        vlayout.addLayout(hlayout, 1)
        vlayout.addWidget(self.logwidget, 0)
        self.setLayout(vlayout)


class MainWindow(QMainWindow):
    def __init__(self, controler):
        super().__init__()
        self.setWindowTitle("TITLE")
        self.mainwidget = MainWidget(self, controler)
        self.setCentralWidget(self.mainwidget)


def main():
    app = QApplication([])
    controler = Controler()
    win = MainWindow(controler)
    controler.init()
    win.show()
    app.exec()


if __name__ == '__main__':
    main()
